//
//  GlyphsToolDrawProtocol.h
//  Glyphs Core
//
//  Created by Georg Seifert on 4.7.07.
//  Copyright 2007 schriftgestaltung.de. All rights reserved.
//

#import <GlyphsCore/GSGlyph.h>
#import <GlyphsCore/GSNode.h>
#import <GlyphsCore/GlyphsToolAuxiliaryDrawing.h>
//#import "GSPath.h"
#import <GlyphsCore/GSInspectorViewController.h>

@class GSWindowController;
/** \brief GlyphsToolDraw: The protocol defining the tool draw plugin protocol
 \ingroup common
 The protocol defining the tool draw plugin protocol.
 Some tool have its own drawing routines. If so, you need to conform to this protocol. If not the last active "drawing" tool will be used.
 \sa GlyphsToolEvent
 */

extern CGFloat ClickTolerance;

@protocol GlyphsToolDraw <GlyphsToolAuxiliaryDrawing>

/// The interface version.
@property (readonly) NSUInteger interfaceVersion;

/// The title of the plugin.
@property (readonly, nonnull) NSString *title;

/// The keydown handler.
/**
@param theEvent The event resulting from the user action.
*/
//- (void)keyDown:(NSEvent*)theEvent;

/// Informs that the mouse has moved.
/**
@param theEvent The event resulting from the user action.
*/
//- (void)mouseMoved:(NSEvent*)theEvent;

/// Informs that the user has pressed the left mouse button.
/**
@param theEvent The event resulting from the user action.
*/
//- (void)mouseDown:(NSEvent*)theEvent;

/** Informs that the user has moved the mouse with the left button pressed.

@param theEvent The event resulting from the user action.
*/
//- (void)mouseDragged:(NSEvent*)theEvent;

/** Informs the receiver that the user has released the left mouse button.

@param theEvent The event resulting from the user action.
*/
//- (void)mouseUp:(NSEvent*)theEvent;

- (void)modifierChanged:(nonnull NSEvent *)theEvent;

/// delegate method to prevent the selection of a temporary tool.
- (BOOL)willSelectTempTool:(nonnull id)tempTool;

/** Draws the foreground for the Layer.

 @param layer      the layer
 @param layerOrigin      The current position in the edit view
 @param active     if the layer is currently active
 @param attributes Some attributes
 */
- (void)drawLayer:(nonnull GSLayer *)layer atPoint:(NSPoint)layerOrigin asActive:(BOOL)active attributes:(nullable NSDictionary *)attributes;

- (void)drawMetricsForLayer:(nonnull GSLayer *)layer atPoint:(NSPoint)layerOrigin asActive:(BOOL)active;

@optional

/** Draws the background for the active layer.

 This should be only additional items, as the actual glyph is drawn somewhere else.
  The drawing happened in font units scale (the view does the transformation). If you need to draw something in a definite size (text) you have to counter scale it.
 @param layer The actual GSLayer instance.
 @param options options
 @see drawForegroundForLayer:
 */
- (void)drawBackgroundForLayer:(nonnull GSLayer *)layer options:(nullable NSDictionary *)options;

/** is called for each not active layer to draws the background for it

 This should be only additional items, as the actual glyph is drawn somewhere else.
  The drawing happened in font units scale (the view does the transformation). If you need to draw something in a definite size (text) you have to counter scale it.
 @param layer The actual GSLayer instance.
 @param options options
 */

- (void)drawBackgroundForInactiveLayer:(nonnull GSLayer *)layer options:(nullable NSDictionary *)options;

/** Draws the background for the Layer.

 @param layer      the layer
 @param layerOrigin      The current position in the edit view
 @param active     if the layer is currently active

 @see drawLayer:atPoint:asActive:attributes:
 */
- (void)drawBackgroundForLayer:(nonnull GSLayer *)layer atPoint:(NSPoint)layerOrigin asActive:(BOOL)active;

/** Draws the foreground for the Layer.

 This should be only additional items, as the actual glyph is drawn somewhere else.
 The drawing happened in font units scale (the view does the transformation). If you need to draw something in a definite size (text) you have to counter scale it.
 @param layer The Layer.
 @param options options
 @see drawBackgroundForLayer:
 */
- (void)drawForegroundForLayer:(nonnull GSLayer *)layer options:(nullable NSDictionary *)options;

/** Is called when the tool becomes active

 This might mean that the tool is clicked or the document window becomes active
 @see willDeactivate
 */
- (void)willActivate;

/** Is called when the tool is deactivated 

 This might mean that the tool is clicked or the document window becomes active
 @see willActivate
 */
- (void)willDeactivate;
/** Draw something is the preview

 If you implement this method, the default preview drawing will be deactivated

 @param previewView The PreviewView to draw in
 */
- (void)drawPreview:(nonnull NSView *)previewView;

/** Return a list of NSViewControllers to place in the inspector box.*/
- (nullable NSArray *)inspectorViewControllers;

/** to prepare drawing outside of the redraw cycle*/
- (void)viewWillDraw;

@end
